/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.VWConfigRootNode;
import filenet.vw.toolkit.admin.VWConfigStatusTableModel;
import filenet.vw.toolkit.admin.VWConfigVWServiceNode;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class VWConfigCommittalDialog
extends VWModalDialog
implements ActionListener,
Runnable {
    private JLabel m_messageLabel = new JLabel();
    private JLabel m_startTimeLabel = new JLabel();
    private JLabel m_elapseTimeLabel = new JLabel();
    private JLabel m_systemRegionLabel = new JLabel();
    private JLabel m_committalStatusLabel = new JLabel(VWResource.InProgress);
    private JButton m_continueButton = new JButton(VWResource.s_continue);
    private JButton m_closeButton = new JButton(VWResource.s_close);
    private JButton m_cancelButton = new JButton(VWResource.s_cancel);
    private JButton m_showErrorButton = new JButton(VWResource.ShowError);
    private JButton m_helpButton = new JButton(VWResource.s_help);
    private JTextArea m_warningMsgTextgArea = new JTextArea();
    private VWConfigBaseNode m_configNode = null;
    private VWTable m_statusTable = null;
    private Frame m_parentFrame = null;
    private JPanel m_topPanel = null;
    private Date m_startTime = null;
    private long m_lStartTimeMillis;
    private boolean m_bStopTimer = false;
    private String[] m_commitOutput = null;
    private Vector m_modifiedNodes = null;
    private VWConfigStatusTableModel m_statusTableModel = null;
    private boolean m_bSuccess = false;

    public VWConfigCommittalDialog(Frame parent, VWConfigBaseNode configNode, String title) {
        super(parent);
        try {
            this.setTitle(title);
            VWAccessibilityHelper.setAccessibility(this, null, title, title);
            Dimension dim = VWStringUtils.stringToDimension("665,385");
            if (dim == null) {
                dim = new Dimension(600, 350);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.m_parentFrame = parent;
            this.m_configNode = configNode;
            this.init();
            this.m_topPanel = this.createTopPanel();
            JPanel subPanel = new JPanel(new BorderLayout(6, 6));
            subPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            subPanel.add((Component)this.m_topPanel, "Center");
            subPanel.add((Component)this.createConfirmationPanel(), "Last");
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            this.getContentPane().add((Component)subPanel, "Center");
            this.setLocationRelativeTo(this.m_parentFrame);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean getStatus() {
        return this.m_bSuccess;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_closeButton || obj == this.m_cancelButton) {
            this.setVisible(false);
        } else if (obj == this.m_continueButton) {
            this.changeToProgressInfoLayout();
            Thread elapsedTimeThread = new Thread(this);
            elapsedTimeThread.start();
            CommittalThread cThread = new CommittalThread("VW Committal Thread");
            cThread.start();
        } else if (obj == this.m_showErrorButton) {
            VWMessageDialog.showOptionDialog(this.m_parentFrame, this.m_commitOutput, 1);
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc055.htm");
        }
    }

    public void releaseResources() {
        if (this.m_messageLabel != null) {
            this.m_messageLabel.removeAll();
            this.m_messageLabel = null;
        }
        if (this.m_startTimeLabel != null) {
            this.m_startTimeLabel.removeAll();
            this.m_startTimeLabel = null;
        }
        if (this.m_elapseTimeLabel != null) {
            this.m_elapseTimeLabel.removeAll();
            this.m_elapseTimeLabel = null;
        }
        if (this.m_systemRegionLabel != null) {
            this.m_systemRegionLabel.removeAll();
            this.m_systemRegionLabel = null;
        }
        if (this.m_committalStatusLabel != null) {
            this.m_committalStatusLabel.removeAll();
            this.m_committalStatusLabel = null;
        }
        if (this.m_continueButton != null) {
            this.m_continueButton.removeActionListener(this);
            this.m_continueButton.removeAll();
            this.m_continueButton = null;
        }
        if (this.m_closeButton != null) {
            this.m_closeButton.removeActionListener(this);
            this.m_closeButton.removeAll();
            this.m_closeButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_showErrorButton != null) {
            this.m_showErrorButton.removeActionListener(this);
            this.m_showErrorButton.removeAll();
            this.m_showErrorButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        if (this.m_warningMsgTextgArea != null) {
            this.m_warningMsgTextgArea.removeAll();
            this.m_warningMsgTextgArea = null;
        }
        this.m_configNode = null;
        this.m_statusTable = null;
        this.m_parentFrame = null;
        this.m_topPanel = null;
        this.m_startTime = null;
        this.m_commitOutput = null;
        if (this.m_modifiedNodes != null) {
            this.m_modifiedNodes.removeAllElements();
            this.m_modifiedNodes = null;
        }
        if (this.m_statusTableModel != null) {
            this.m_statusTableModel.releaseResources();
            this.m_statusTableModel = null;
        }
        this.removeAll();
    }

    public void run() {
        try {
            String sHours = null;
            String sMinutes = null;
            String sSeconds = null;
            String prevTime = "";
            while (!this.m_bStopTimer) {
                int seconds;
                String sTime = null;
                long currentTimeMillis = System.currentTimeMillis();
                long elapsedTimeSeconds = (currentTimeMillis - this.m_lStartTimeMillis) / 1000L;
                int hours = (int)(elapsedTimeSeconds / 3600L);
                sHours = hours < 10 ? "0" + String.valueOf(hours) : String.valueOf(hours);
                int minutes = (int)((elapsedTimeSeconds %= 3600L) / 60L);
                sMinutes = minutes < 10 ? "0" + String.valueOf(minutes) : String.valueOf(minutes);
                if ((sTime = VWResource.ElapseTimeFormat.toString(sHours, sMinutes, sSeconds = (seconds = (int)(elapsedTimeSeconds % 60L)) < 10 ? "0" + String.valueOf(seconds) : String.valueOf(seconds))).compareTo(prevTime) != 0) {
                    this.m_elapseTimeLabel.setText(sTime);
                    prevTime = sTime;
                    VWAccessibilityHelper.setAccessibility(this.m_elapseTimeLabel, this, this.m_elapseTimeLabel.getText(), this.m_elapseTimeLabel.getText());
                }
                Thread.yield();
                Thread.sleep(1000L);
            }
            VWAccessibilityHelper.setAccessibility(this.m_elapseTimeLabel, this, this.m_elapseTimeLabel.getText(), this.m_elapseTimeLabel.getText());
        }
        catch (InterruptedException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.m_continueButton.requestFocus();
    }

    private void init() {
        VWConfigRegionNode rNode = null;
        switch (this.m_configNode.getType()) {
            case 17: {
                this.m_modifiedNodes = ((VWConfigRootNode)this.m_configNode).getModifiedNodeList();
                this.m_messageLabel.setText(VWResource.CommitGlobal);
                break;
            }
            case 18: {
                VWConfigVWServiceNode sNode = (VWConfigVWServiceNode)this.m_configNode;
                this.m_modifiedNodes = this.getServiceModifiedNode(sNode);
                this.m_messageLabel.setText(VWResource.CommitVWService.toString(sNode.getName()));
                break;
            }
            case 19: {
                rNode = (VWConfigRegionNode)this.m_configNode;
                this.m_modifiedNodes = this.getRegionModifiedNode(rNode);
                this.m_messageLabel.setText(VWResource.CommitVWServiceRegion.toString(rNode.getServiceName(), rNode.getRegionIDString()));
                break;
            }
            default: {
                rNode = (VWConfigRegionNode)this.m_configNode.findAncestorNode(19);
                this.m_modifiedNodes = this.getRegionModifiedNode(rNode);
                this.m_messageLabel.setText(VWResource.CommitVWServiceRegion.toString(rNode.getServiceName(), rNode.getRegionIDString()));
            }
        }
        int sz = this.m_modifiedNodes.size();
        for (int i = 0; i < sz; ++i) {
            VWConfigBaseNode aNode = (VWConfigBaseNode)this.m_modifiedNodes.elementAt(i);
            aNode.countWorkItemsAffected();
        }
        this.m_statusTableModel = new VWConfigStatusTableModel(this.m_modifiedNodes, true);
        this.m_statusTable = new VWTable(this.m_statusTableModel);
        this.m_statusTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
        this.m_statusTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
    }

    private void changeToProgressInfoLayout() {
        this.getContentPane().removeAll();
        JPanel subPanel = new JPanel(new BorderLayout(6, 6));
        subPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        subPanel.add((Component)this.m_topPanel, "Center");
        subPanel.add((Component)this.createProgressInfoPanel(), "Last");
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        this.getContentPane().add((Component)subPanel, "Center");
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private Vector getServiceModifiedNode(VWConfigVWServiceNode sNode) {
        Vector<VWConfigBaseNode> vList = new Vector<VWConfigBaseNode>();
        VWConfigRootNode rootNode = (VWConfigRootNode)sNode.findAncestorNode(17);
        Vector globalList = rootNode.getModifiedNodeList();
        if (globalList != null) {
            int childCount = sNode.getChildCount();
            String serviceName = sNode.getServiceName();
            for (int c = 0; c < childCount; ++c) {
                VWConfigRegionNode rNode = (VWConfigRegionNode)sNode.getChildAt(c);
                int regionId = rNode.getRegionID();
                for (int i = 0; i < globalList.size(); ++i) {
                    VWConfigBaseNode aNode = (VWConfigBaseNode)globalList.elementAt(i);
                    if (aNode.getRegionID() != regionId || VWStringUtils.compare(serviceName, aNode.getServiceName()) != 0) continue;
                    vList.add(aNode);
                }
            }
        }
        return vList;
    }

    private Vector getRegionModifiedNode(VWConfigRegionNode rNode) {
        Vector<VWConfigBaseNode> vList = new Vector<VWConfigBaseNode>();
        VWConfigRootNode rootNode = (VWConfigRootNode)rNode.findAncestorNode(17);
        Vector globalList = rootNode.getModifiedNodeList();
        if (globalList != null) {
            String serviceName = rNode.getServiceName();
            int regionId = rNode.getRegionID();
            for (int i = 0; i < globalList.size(); ++i) {
                VWConfigBaseNode aNode = (VWConfigBaseNode)globalList.elementAt(i);
                if (aNode.getRegionID() != regionId || VWStringUtils.compare(serviceName, aNode.getServiceName()) != 0) continue;
                vList.add(aNode);
            }
        }
        return vList;
    }

    private JPanel createTopPanel() {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel(new BorderLayout(6, 6));
            mainPanel.add((Component)this.m_messageLabel, "First");
            mainPanel.add((Component)new JScrollPane(this.m_statusTable), "Center");
            VWAccessibilityHelper.setAccessibility(this.m_messageLabel, this, this.m_messageLabel.getText(), this.m_messageLabel.getText());
            VWAccessibilityHelper.setAccessibility(this.m_statusTable, this, VWResource.ChangesToCommitTable, VWResource.ChangesToCommitTable);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    private JPanel createConfirmationPanel() {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel(new BorderLayout(6, 6));
            Color bgColor = mainPanel.getBackground();
            this.m_warningMsgTextgArea.setBackground(bgColor);
            this.m_warningMsgTextgArea.setEditable(false);
            this.m_warningMsgTextgArea.setLineWrap(true);
            this.m_warningMsgTextgArea.setWrapStyleWord(true);
            this.m_warningMsgTextgArea.setText(VWResource.CommitWarningMessage);
            this.m_warningMsgTextgArea.setBorder(BorderFactory.createEmptyBorder());
            mainPanel.add((Component)this.m_warningMsgTextgArea, "Center");
            mainPanel.add((Component)this.createConfirmationButtonPanel(), "Last");
            this.m_warningMsgTextgArea.setFocusable(false);
            VWAccessibilityHelper.setAccessibility(this.m_warningMsgTextgArea, this, VWResource.CommitWarningMessage, VWResource.CommitWarningMessage);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    private JPanel createConfirmationButtonPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.anchor = 23;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            mainPanel.add((Component)this.m_continueButton, gbConst);
            mainPanel.add((Component)this.m_cancelButton, gbConst);
            mainPanel.add((Component)this.m_helpButton, gbConst);
            this.m_continueButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_continueButton, this, this.m_continueButton.getText(), this.m_continueButton.getText());
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, this.m_cancelButton.getText(), this.m_cancelButton.getText());
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, this.m_helpButton.getText(), this.m_helpButton.getText());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    private JPanel createProgressInfoPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.applyComponentOrientation(this.m_parentFrame.getComponentOrientation());
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 0;
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.insets = new Insets(2, 10, 2, 10);
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            JLabel label = new JLabel(VWResource.s_label.toString(VWResource.StartTime));
            mainPanel.add((Component)label, gbConst);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.StartTime, VWResource.StartTime);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            DateFormat df = DateFormat.getDateTimeInstance(2, 3);
            this.m_startTime = new Date();
            this.m_lStartTimeMillis = System.currentTimeMillis();
            this.m_startTimeLabel.setText(df.format(this.m_startTime));
            mainPanel.add((Component)this.m_startTimeLabel, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_startTimeLabel, this, this.m_startTimeLabel.getText(), this.m_startTimeLabel.getText());
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.gridwidth = 1;
            gbConst.weightx = 0.0;
            label = new JLabel(VWResource.s_label.toString(VWResource.ElapsedTime));
            mainPanel.add((Component)label, gbConst);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.ElapsedTime, VWResource.ElapsedTime);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            this.m_elapseTimeLabel.setText(VWResource.ElapseTimeFormat.toString("00", "00", "00"));
            mainPanel.add((Component)this.m_elapseTimeLabel, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_elapseTimeLabel, this, this.m_elapseTimeLabel.getText(), this.m_elapseTimeLabel.getText());
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.gridwidth = 1;
            gbConst.weightx = 0.0;
            label = new JLabel(VWResource.s_label.toString(VWResource.Region));
            mainPanel.add((Component)label, gbConst);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.Region, VWResource.Region);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            mainPanel.add((Component)this.m_systemRegionLabel, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_systemRegionLabel, this, this.m_systemRegionLabel.getText(), this.m_systemRegionLabel.getText());
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.gridwidth = 1;
            gbConst.weightx = 0.0;
            label = new JLabel(VWResource.s_label.toString(VWResource.s_status));
            mainPanel.add((Component)label, gbConst);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_status, VWResource.s_status);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            mainPanel.add((Component)this.m_committalStatusLabel, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_committalStatusLabel, this, this.m_committalStatusLabel.getText(), this.m_committalStatusLabel.getText());
            gbConst.fill = 2;
            gbConst.insets = new Insets(10, 10, 10, 10);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            mainPanel.add((Component)this.createProgressInfoButtonPanel(), gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    private JPanel createProgressInfoButtonPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.anchor = 23;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            this.m_showErrorButton.setEnabled(false);
            this.m_showErrorButton.setFocusable(false);
            mainPanel.add((Component)this.m_showErrorButton, gbConst);
            this.m_closeButton.setEnabled(false);
            this.m_closeButton.setFocusable(false);
            mainPanel.add((Component)this.m_closeButton, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_showErrorButton, this, this.m_showErrorButton.getText(), this.m_showErrorButton.getText());
            VWAccessibilityHelper.setAccessibility(this.m_closeButton, this, this.m_closeButton.getText(), this.m_closeButton.getText());
            this.m_showErrorButton.addActionListener(this);
            this.m_closeButton.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performCommit() {
        block12: {
            try {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    switch (this.m_configNode.getType()) {
                        case 17: {
                            this.m_bSuccess = this.performGlobalCommit((VWConfigRootNode)this.m_configNode);
                            ** break;
                        }
                        case 18: {
                            sNode = (VWConfigVWServiceNode)this.m_configNode;
                            this.m_bSuccess = this.performVWServiceCommit(sNode);
                            ** break;
                        }
                        case 19: {
                            this.m_bSuccess = this.performRegionCommit((VWConfigRegionNode)this.m_configNode);
                            ** break;
                        }
                    }
                    rNode = (VWConfigRegionNode)this.m_configNode.findAncestorNode(19);
                    this.m_bSuccess = this.performRegionCommit(rNode);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    var4_5 = null;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break block12;
                }
lbl24:
                // 4 sources

                var4_4 = null;
            }
            catch (Throwable var3_7) {
                var4_6 = null;
                this.setCursor(Cursor.getPredefinedCursor(0));
                throw var3_7;
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.m_closeButton.setEnabled(true);
        if (!this.m_bSuccess) {
            this.m_showErrorButton.setEnabled(true);
            this.m_committalStatusLabel.setText(VWResource.s_error);
        } else {
            this.m_committalStatusLabel.setText(VWResource.Success);
        }
        this.m_closeButton.setFocusable(this.m_closeButton.isEnabled());
        this.m_showErrorButton.setFocusable(this.m_showErrorButton.isEnabled());
        this.m_closeButton.setFocusable(this.m_closeButton.isEnabled());
        VWAccessibilityHelper.setAccessibility(this.m_committalStatusLabel, this, this.m_committalStatusLabel.getText(), this.m_committalStatusLabel.getText());
        this.m_bStopTimer = true;
        if (this.m_showErrorButton.isEnabled()) {
            this.m_showErrorButton.requestFocus();
            return;
        }
        if (this.m_closeButton.isEnabled() == false) return;
        this.m_closeButton.requestFocus();
    }

    private boolean performRegionCommit(VWConfigRegionNode rNode) {
        boolean bSuccess = false;
        try {
            this.m_systemRegionLabel.setText(rNode.getRegionIDString() + " (" + rNode.getServiceName() + ") ");
            String[] sOutput = rNode.commitChanges();
            if (sOutput != null) {
                int sz = sOutput.length;
                this.m_commitOutput = new String[sz + 2];
                this.m_commitOutput[0] = VWResource.s_label.toString(VWResource.VWService) + rNode.getServiceName();
                this.m_commitOutput[1] = VWResource.s_label.toString(VWResource.Region) + rNode.getRegionIDString();
                for (int i = 0; i < sz; ++i) {
                    this.m_commitOutput[i + 2] = sOutput[i];
                }
                this.m_bStopTimer = true;
                this.m_closeButton.setEnabled(true);
            } else {
                rNode.refresh(false);
                bSuccess = true;
            }
            VWAccessibilityHelper.setAccessibility(this.m_systemRegionLabel, this, this.m_systemRegionLabel.getText(), this.m_systemRegionLabel.getText());
        }
        catch (Exception ex) {
            this.m_bStopTimer = true;
            this.m_closeButton.setEnabled(true);
            VWDebug.logException(ex);
        }
        this.m_closeButton.setFocusable(this.m_closeButton.isEnabled());
        return bSuccess;
    }

    private boolean performVWServiceCommit(VWConfigVWServiceNode sNode) {
        boolean bSuccess = false;
        try {
            VWConfigRegionNode rNode;
            int childCount = sNode.getChildCount();
            for (int i = 0; i < childCount && (bSuccess = this.performRegionCommit(rNode = (VWConfigRegionNode)sNode.getChildAt(i))); ++i) {
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bSuccess;
    }

    private boolean performGlobalCommit(VWConfigRootNode rNode) {
        boolean bSuccess = false;
        try {
            VWConfigVWServiceNode sNode;
            int childCount = rNode.getChildCount();
            for (int i = 0; i < childCount && (bSuccess = this.performVWServiceCommit(sNode = (VWConfigVWServiceNode)rNode.getChildAt(i))); ++i) {
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bSuccess;
    }

    class CommittalThread
    extends Thread {
        public CommittalThread(String theName) {
            super(theName);
        }

        public void run() {
            VWConfigCommittalDialog.this.performCommit();
            VWConfigCommittalDialog.this.m_bStopTimer = true;
        }
    }
}

